
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 2000, 2001 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *
 * events.c (win)
 *
 * Copyright (C) 2000, 2001 Criterion Technologies.
 *
 * Original author: John Irwin.
 *
 * Purpose: Sky dome creator for RW3.
 *
 ****************************************************************************/

#include "rwcore.h"

#include "skeleton.h"
#include "menu.h"

#include "main.h"
#include "transform.h"

static RwBool SkyDomeTranslating = FALSE;
static RwBool SkyDomeRotating = FALSE;
static RwBool SunRotating = FALSE;
static RwBool CameraHFoVing = FALSE;

static RwBool Ctrl = FALSE;

RwBool CameraPointing = FALSE;



/*
 *****************************************************************************
 */
static RsEventStatus
HandleLeftButtonDown(RsMouseStatus *mouseStatus)
{
    if( Ctrl )
    {
        SunRotating = TRUE;
    }
    else
    {
        if( PreviewOn )
        {
            CameraPointing = TRUE;
        }
        else
        {
            SkyDomeRotating = TRUE;
        }
    }

    return rsEVENTPROCESSED;
}


static RsEventStatus
HandleLeftButtonUp(RsMouseStatus *mouseStatus)
{
    SunRotating = FALSE;
    CameraPointing = FALSE;
    SkyDomeRotating = FALSE;

    return rsEVENTPROCESSED;
}



/*
 *****************************************************************************
 */
static RsEventStatus
HandleRightButtonDown(RsMouseStatus *mouseStatus)
{
    if( PreviewOn )
    {
        CameraHFoVing = TRUE;
    }
    else
    {
        SkyDomeTranslating = TRUE;
    }

    return rsEVENTPROCESSED;
}

static RsEventStatus
HandleRightButtonUp(RsMouseStatus *mouseStatus)
{
    CameraHFoVing = FALSE;
    SkyDomeTranslating = FALSE;

    return rsEVENTPROCESSED;
}


/*
 *****************************************************************************
 */
static RsEventStatus 
HandleMouseMove(RsMouseStatus *mouseStatus)
{
    if( SkyDomeRotating )
    {
        SkyDomeRotate(mouseStatus->delta.x, -mouseStatus->delta.y);

        return rsEVENTPROCESSED;
    }
    
    if( SkyDomeTranslating )
    {
        SkyDomeTranslate(mouseStatus->delta.y * -0.01f);

        return rsEVENTPROCESSED;
    }

    if( SunRotating )
    {
        RwReal deltaZD, deltaAZ;

        deltaZD = mouseStatus->delta.y * 0.1f;

        if( PreviewOn )
        { 
            deltaAZ = mouseStatus->delta.x * -0.1f;
        }
        else
        {
            deltaAZ = mouseStatus->delta.x * 0.1f;
        }

        SkyDomeRotateSun(deltaZD, deltaAZ);

        return rsEVENTPROCESSED;
    }

    if( CameraPointing )
    {
        RwReal deltaEl, deltaAz;

        deltaEl = -mouseStatus->delta.y * 0.1f;
        deltaAz = -mouseStatus->delta.x * 0.1f;

        CameraPoint(deltaEl, deltaAz);

        return rsEVENTPROCESSED;
    }

    if( CameraHFoVing )
    {
        CameraUpdateHFoV(-mouseStatus->delta.y * 0.1f);

        return rsEVENTPROCESSED;
    }

    return rsEVENTNOTPROCESSED;
}


/*
 *****************************************************************************
 */
static RsEventStatus 
MouseHandler(RsEvent event, void *param)
{
    /*
     * Let the menu system have a look-in first...
     */
    if( RdMenuMouseHandler(event, param) == rsEVENTPROCESSED )
    {
        return rsEVENTPROCESSED;
    }

    /*
     * ...then the application events, if necessary...
     */
    switch( event )
    {
        case rsLEFTBUTTONDOWN:
        {
            return HandleLeftButtonDown((RsMouseStatus *)param);
        }

        case rsLEFTBUTTONUP:
        {
            return HandleLeftButtonUp((RsMouseStatus *)param);
        }

        case rsRIGHTBUTTONDOWN:
        {
            return HandleRightButtonDown((RsMouseStatus *)param);
        }

        case rsRIGHTBUTTONUP:
        {
            return HandleRightButtonUp((RsMouseStatus *)param);
        }

        case rsMOUSEMOVE:
        {
            return HandleMouseMove((RsMouseStatus *)param);
        }

        default:
        {
            return rsEVENTNOTPROCESSED;
        }
    }
}


/*
 *****************************************************************************
 */
static RsEventStatus 
HandleKeyDown(RsKeyStatus *keyStatus)
{
    switch( keyStatus->keyCharCode )
    {
        case rsLCTRL:
        case rsRCTRL:
        {
            /*
             * LEFT-CTRL or RIGHT-CTRL...
             */
            Ctrl = TRUE;

            return rsEVENTPROCESSED;
        }

        default:
        {
            return rsEVENTNOTPROCESSED;
        }
    }
}


/*
 *****************************************************************************
 */
static RsEventStatus 
HandleKeyUp(RsKeyStatus *keyStatus)
{
    switch( keyStatus->keyCharCode )
    {
        case rsLCTRL:
        case rsRCTRL:
        {
            /*
             * LEFT-CTRL or RIGHT-CTRL...
             */
            Ctrl = FALSE;

            return rsEVENTPROCESSED;
        }

        default:
        {
            return rsEVENTNOTPROCESSED;
        }
    }
}


/*
 *****************************************************************************
 */
static RsEventStatus 
KeyboardHandler(RsEvent event, void *param)
{
    /*
     * Let the menu system have a look-in first...
     */
    if( RdMenuKeyboardHandler(event, param) == rsEVENTPROCESSED )
    {
        return rsEVENTPROCESSED;
    }

    /*
     * ...then the application events, if necessary...
     */
    switch( event )
    {
        case rsKEYDOWN:
        {
            return HandleKeyDown((RsKeyStatus *)param);
        }

        case rsKEYUP:
        {
            return HandleKeyUp((RsKeyStatus *)param);
        }

        default:
        {
            return rsEVENTNOTPROCESSED;
        }
    }
}


/*
 *****************************************************************************
 */
RwBool
AttachInputDevices(void)
{
    RsInputDeviceAttach(rsKEYBOARD, KeyboardHandler);

    RsInputDeviceAttach(rsMOUSE, MouseHandler);

    return TRUE;
}

/*
 *****************************************************************************
 */
