
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 2000, 2001 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *
 * skycolor.h
 *
 * Copyright (C) 2000, 2001 Criterion Technologies.
 *
 * Original author: John Irwin.
 *
 * Purpose: Sky dome creator for RW3.
 *
 ****************************************************************************/

#ifndef SKYCOLOR_H
#define SKYCOLOR_H

#include "rwcore.h"
#include "rpworld.h"

extern RwReal SunZenithDist;
extern RwReal SunAzimuth;
extern RwV3d SunPos;

extern RwReal Turbidity;
extern RwReal Exposure;


#ifdef    __cplusplus
extern "C"
{
#endif  /* __cplusplus */

extern RwBool InitializeColor(void);

extern RwBool SkyDomeResizeSkyColorBuffer(RwInt32 numVert);
extern void SkyDomeDestroySkyColorBuffer(void);

extern void SkyDomeInitializeParams(RwReal sunZD, RwReal sunAZ, RwReal turb);

extern void SkyDomeCalculateColors(RwReal sunZD, RwReal sunAZ, RpAtomic *atomic);

extern void SkyDomeSetPrelights(RpAtomic *atomic, RwBool skyColorsOn);

#ifdef    __cplusplus
}
#endif  /* __cplusplus */

#endif  /* SKYCOLOR_H */


