
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 2000, 2001 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *
 * main.h
 *
 * Copyright (C) 2000, 2001 Criterion Technologies.
 *
 * Original author: John Irwin.
 *
 * Purpose: Sky dome creator for RW3.
 *
 ****************************************************************************/

#ifndef MAIN_H
#define MAIN_H

#include "rwcore.h"
#include "rpworld.h"
#include "rtcharse.h"

extern RwRaster *Pointer;

extern RwBool FPSOn;

extern RwInt32 FrameCounter;
extern RwInt32 FramesPerSecond;

extern RwRGBA ForegroundColor;
extern RwRGBA BackgroundColor;

extern RwBool SkyColorsOn;
extern RwBool GroundOn;
extern RwBool WireMeshOn;
extern RwBool NormalsOn;
extern RwBool PreviewOn;
extern RwBool LensEffectOn;
extern RwBool DisplayDataOn;

extern RpWorld *World;
extern RwCamera *Camera;
extern RtCharset *Charset;
extern RwTexture *GroundTex;

extern RpClump *SkyDomeClump;
extern RpAtomic *SkyDomeAtomic;

extern RwReal CameraViewWindow;
extern RwReal CameraHFoV;

extern RwInt32 AzRes;
extern RwInt32 ElRes;

#endif  /* MAIN_H */


