
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 1999, 2000 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *
 * play.h
 *
 * Copyright (C) 1999, 2000 Criterion Technologies.
 *
 * Original author: John Irwin.
 *
 * Purpose: To illustrate collision detection and rigid-body dynamics.
 *
 ****************************************************************************/

#ifndef PLAY_H
#define PLAY_H

#include "rwcore.h"
#include "rpworld.h"

#include "dice.h"

extern RwInt32 PickedDieValues[NUMDICE];

extern RwInt32 CurrentDieValue;

extern RwBool DiceRolling;
extern RwInt32 RollNumber;
extern RwInt32 NumInactiveDice;

extern RwBool CurrentDieOn;

extern RwChar RollCaption[128];

extern RwBool DiePreview;
extern RwInt32 DiePreviewX;
extern RwInt32 DiePreviewY;


#ifdef    __cplusplus
extern "C"
{
#endif  /* __cplusplus */

extern RwBool DiceRoll(void);

extern void DicePreview(RwInt32 x, RwInt32 y);

extern void DiceSelect(RwInt32 x, RwInt32 y);

extern void GatherRemainingDieValues(void);

#ifdef    __cplusplus
}
#endif  /* __cplusplus */

#endif  /* PLAY_H */


