
/****************************************************************************
 *
 * This file is a product of Criterion Software Ltd.
 *
 * This file is provided as is with no warranties of any kind and is
 * provided without any obligation on Criterion Software Ltd.
 * or Canon Inc. to assist in its use or modification.
 *
 * Criterion Software Ltd. and Canon Inc. will not, under any
 * circumstances, be liable for any lost revenue or other damages
 * arising from the use of this file.
 *
 * Copyright (c) 1999, 2000 Criterion Software Ltd.
 * All Rights Reserved.
 *
 */

/****************************************************************************
 *
 * dice.h
 *
 * Copyright (C) 1999, 2000 Criterion Technologies.
 *
 * Original author: John Irwin.
 *
 * Purpose: To illustrate collision detection and rigid-body dynamics.
 *
 ****************************************************************************/

#ifndef DICE_H
#define DICE_H

#include "rwcore.h"
#include "rpworld.h"

#define NUMDICE (5)

#define MINENERGY (0.1f)

typedef struct
{
    RwMatrix *matrix;

    RwV3d velocityCM;
    RwV3d angularMomentum;

    RwV3d forceCM;
    RwV3d torque;

    RwMatrix *worldInertiaTensor;
    RwMatrix *invWorldInertiaTensor;
    RwV3d angularVelocity;
}
State;

typedef struct
{
    RpAtomic *atomic;

    RwReal oneOverMass;

    RwReal coeffRestitution;

    RwMatrix *objectInertiaTensor;
    RwMatrix *invObjectInertiaTensor;
 
    State states[2];

    RwBool active;
}
RigidBody;

extern RigidBody Dice[NUMDICE];

extern RwBool SystemEnergyInfoOn;
extern RwBool CameraParametersOn;

extern RwBool GravityOn;
extern RwBool JumpStartOn;
extern RwV3d JumpAttractor;

extern RwReal RollTime;
extern RwReal TotalKineticEnergy;
extern RwReal TotalPotentialEnergy;
extern RwReal TotalSystemEnergy;
extern RwReal EnergyThreshold;


#ifdef    __cplusplus
extern "C"
{
#endif  /* __cplusplus */

extern RwBool SetupDice(RpAtomic *dice[]);

extern void DestroyDice(void);

extern void InitializeDice(void);

extern void RunSimulation(RwUInt32 milliseconds);

extern void SimulationSingleStep(void);

extern void ResetDiceOnTable(void);

#ifdef    __cplusplus
}
#endif  /* __cplusplus */

#endif  /* DICE_H */


